/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.enchant;

import com.lothrazar.cyclic.enchant.EnchantmentCyclic;
import com.lothrazar.cyclic.util.UtilStepHeight;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class StepEnchant
extends EnchantmentCyclic {
    private static final String NBT_ON = "cyclic_stepenchant";
    public static final String ID = "step";
    public static ForgeConfigSpec.BooleanValue CFG;

    public StepEnchant(Enchantment.Rarity rarityIn, EnchantmentCategory typeIn, EquipmentSlot ... slots) {
        super(rarityIn, typeIn, slots);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)CFG.get();
    }

    public int m_6586_() {
        return 1;
    }

    public boolean m_6081_(ItemStack stack) {
        boolean yes = stack.m_41720_() instanceof ArmorItem && ((ArmorItem)stack.m_41720_()).m_40402_() == EquipmentSlot.LEGS;
        return yes;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return this.m_6081_(stack);
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (!(event.getEntityLiving() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntityLiving();
        ItemStack armor = player.m_6844_(EquipmentSlot.LEGS);
        int level = 0;
        if (!armor.m_41619_() && EnchantmentHelper.m_44831_((ItemStack)armor) != null && EnchantmentHelper.m_44831_((ItemStack)armor).containsKey((Object)this)) {
            level = (Integer)EnchantmentHelper.m_44831_((ItemStack)armor).get((Object)this);
        }
        if (level > 0) {
            this.turnOn(player, armor);
        } else {
            this.turnOff(player, armor);
        }
    }

    private void turnOn(Player player, ItemStack armor) {
        player.getPersistentData().m_128379_(NBT_ON, true);
        UtilStepHeight.enableStepHeight(player);
    }

    private void turnOff(Player player, ItemStack armor) {
        if (player.getPersistentData().m_128441_(NBT_ON) && player.getPersistentData().m_128471_(NBT_ON)) {
            UtilStepHeight.disableStepHeight(player);
            player.getPersistentData().m_128379_(NBT_ON, false);
        }
    }
}

